#!/bin/sh

#
# Description:
#   Installation script triggerred by RPM install
#   Check the revision of firmware to upgrade
# 

# Variables
BIOS_PATH=/usr/share/biosfw
if [ -z "$1" ]; then
    BIOS_IMG=./NGRE_v040_flash_v02.bin 
else
    BIOS_IMG=$1
fi

echo "CAUTION: DO NOT POWERCYCLE or REBOOT THE CHASSIS"
printf "Programming BIOS firmware ... "
cd ${BIOS_PATH}
insmod ${BIOS_PATH}/isfl_drv_x64.ko

if [ -f "${BIOS_IMG}" ]; then
    ./H2OFFT-Lx64 ${BIOS_IMG} -BIOS -ALL -N
    if [ $? -eq 0 ]
    then
        printf " done.\n";
    else
        printf " failed!\n";
    fi
fi

