#!/bin/bash

TARGET_DIR=/usr/share/biosfw
EXE_FILE=H2OFFT-Lx64
FLASHROM=/usr/sbin/flashrom

ORIG_FLASH=$(cat  /sys/devices/platform/ngpmb-cpld/flash_select)
cd ${TARGET_DIR}

function cleanup()
{
    CURR_FLASH=$(cat  /sys/devices/platform/ngpmb-cpld/flash_select)

    if [ "$ORIG_FLASH" != "$CURR_FLASH" ]; then
	    # Reset it back to avoid funny behavior
	    echo $ORIG_FLASH > /sys/devices/platform/ngpmb-cpld/flash_select
	    ${FLASHROM} -p internal > /dev/null 2>&1
    fi
}

trap cleanup EXIT

function print_version() 
{
    # Hack!! Insyde utility doesn't work well with flash select change. This
    # seems to help. Temporary workaround till we move to flashrom entirely
    ${FLASHROM} -p internal > /dev/null 2>&1
    ./${EXE_FILE} -SC

}

function print_long_version ()
{
    print_version | grep Version  | awk '{print $5}'
}

function print_short_version ()
{
    print_long_version | awk -F. '{print $2 "." $3 "." $4 "." $5}'
}

function select_flash_a()
{
    # Select flash A
    echo A > /sys/devices/platform/ngpmb-cpld/flash_select
}

function select_flash_b()
{
    # Select flash B
    echo B > /sys/devices/platform/ngpmb-cpld/flash_select
}

function print_selected_flash() 
{
    echo "Flash `cat  /sys/devices/platform/ngpmb-cpld/flash_select`:"
}

function get_stout_bios_version ()
{
    FLASH="X"
    while getopts ":aAbBlLsS" OPT; do
        case "$OPT" in
            a|A)
                FLASH="A"
                ;;
            b|B)
                FLASH="B"
                ;;
            l|L)
                VERSION="LONG"
                ;;
            s|S)
                VERSION="SHORT"
                ;;
        esac
    done

    if [ "$FLASH" == "X" ]; then
        select_flash_a
        print_selected_flash
        print_version

        select_flash_b
        print_selected_flash
        print_version
        return
    elif [ "$FLASH" == "A" ]; then
        select_flash_a
    elif [ "$FLASH" == "B" ]; then
        select_flash_b
    fi
    if [ "$VERSION" == "LONG" ]; then
        print_long_version
    elif [ "$VERSION" == "SHORT" ]; then
        print_short_version
    else
        print_selected_flash
        print_version
    fi
}

# Entry point
# bios_version check is used to check whether the FPC has a secure BIOS
bios_version=$(dmidecode -s bios-version | grep -v "^#" | grep ^[A-Z]*\_[A-Z]*\_[A-Z0-9]*[0-9]\_ | sed s/^[A-Z]*\_[A-Z]*\_[A-Z0-9]*[0-9]\_//)
if [ -z "$bios_version" ]; then
    get_stout_bios_version $@
else
    echo "$bios_version"
fi
exit $?
