#!/bin/sh


#
# Description: 
#   bios_pkg_install.sh is run aling with bios_pkg.tgz package copied form Junos
#   jfirmware software package
#   THis script extracts bios_pkg.tgz and installs the rpm packed inside the tgz file. 

PKG_NAME=bios_pkg-1.0-0.x86_64.rpm
PKG_PATH=/usr/share/biosfw/
EXT_PATH=/tmp
# Supported VMHOST Major Ver
SUP_VMHOST_MAJ=1

extract_pkg()
{
    err=0
    PKG_NAME=`ls ${EXT_PATH}/bios_pkg-*.rpm`
    err=$((err + $?))
    if [ ${err} -ne 0 ]; then
        echo "package lookup failed"
        return $err
    fi

    re='^[0-9]+$'
    CUR_VMHOST_MAJ=`sh /etc/install/vmhost_version_get_major.sh`
    err=$((err + $?))
    if ! [[ $CUR_VMHOST_MAJ =~ $re ]] ; then
        echo "VMHost version compatibility check failed"
        return $err
    fi

    if [ "$CUR_VMHOST_MAJ" -lt "$SUP_VMHOST_MAJ" ]; then
        echo "VMHost version too old for bios firmware"
        err=$((err + 1))
        return $err
    fi
    return 0
}

rpm_install()
{

    rpm -ivh  --force  --nodeps $PKG_NAME
    if [ $? -ne 0 ]; then
        printf "Installing $PKG_NAME ... failed!\n"
        return 1
    else
        printf "Installing $PKG_NAME ... done.\n"
    fi

    return 0
}


rpm_uninstall()
{
    printf "Uninstalling $PKG_NAME  ..."

    rpm -ev  --nodeps $PKG_NAME
    if [ $? -ne 0 ]; then
        printf "failed! " 
    else
        printf "done. " 
    fi
    printf "\n"
}

cleanup_files()
{
        rm -f ${EXT_PATH}/bios_pkg*  >/dev/null
}

main ()
{
    while getopts ":ud" opt; do
        case $opt in
            u)
                extract_pkg
                if [ $? -eq 0 ]; then
                    rpm_install
                else
                    printf "extract Failed!"
                fi
                cleanup_files
                exit 0
                ;;
            d)
                rpm_uninstall
                cleanup_files
                exit 0
                ;;
            \?)
                printf "Failed: $0 -$OPTARG unknown option"
                cleanup_files
                exit 1
                ;;
            :)
                printf "Failed: $0 -$OPTARG requires argument"
                cleanup_files
                exit 2
                ;;
        esac
    done

    # No arguments:
    printf "$0: no changes applied!"
    cleanup_files
}

# Script starts here
main $@
