#!/bin/sh


#
# Description: 
#   i40e_pkg_install.sh is run aling with i40e_pkg.tgz package copied form Junos
#   jfirmware software package
#   This script extracts i40e_pkg.tgz and installs the rpm packed inside the tgz file. 

PKG_NAME=i40e_pkg-1.0-0.x86_64.rpm
NVM_UPDATE_PKG_NAME=XL710_NVMUpdatePackage_v6_01_Linux.tar.gz
# Supported VMHOST Major Ver
SUP_VMHOST_MAJ=1

extract_pkg()
{
    err=0
    PKG_NAME=`ls /tmp/i40e_pkg-*.rpm`
    err=$((err + $?))
    if [ ${err} -ne 0 ]; then
        echo "package lookup failed"
        return $err
    fi

    re='^[0-9]+$'
    CUR_VMHOST_MAJ=`sh /etc/install/vmhost_version_get_major.sh`
    err=$((err + $?))
    if ! [[ $CUR_VMHOST_MAJ =~ $re ]] ; then
        echo "VMHost version compatibility check failed"
        return $err
    fi
    
    if [ "$CUR_VMHOST_MAJ" -lt "$SUP_VMHOST_MAJ" ]; then
        echo "VMHost version too old for i40e firmware"
        err=$((err + 1))
        return $err
    fi
    return 0
}

rpm_install()
{

    rpm -ivh  --force  --nodeps $PKG_NAME
    if [ $? -ne 0 ]; then
        printf "Installation of $PKG_NAME ... failed"
    else
        printf "Installation of $PKG_NAME ... done"
        cd /usr/share/i40e/
        tar -xf $NVM_UPDATE_PKG_NAME
        rm -f $NVM_UPDATE_PKG_NAME
        chmod -R 755 *
        cd /usr/share/i40e/XL710/Linux_x64 
        ls *.bin | egrep -v "^(XL710_6p01_KR_KR4_NCSI_CFGID2p4_Dual.bin|XL710_4p42_KR_KR4_NCSI_CFGID2p4_Dual.bin)" | xargs rm -f
    fi
    printf "\n"
}


rpm_uninstall()
{
    printf "Uninstalling $PKG_NAME is skipped ..."

    #rpm -ev  --nodeps $PKG_NAME
    if [ $? -ne 0 ]; then
        printf "failed! " 
    else
        printf "done. " 
    fi
    printf "\n"
}

cleanup_files()
{
        rm -f /tmp/i40e_pkg*  >/dev/null
}

main ()
{
    # Usage:
    # -u : upgrades/installs i40e
    # -d : uninstalls i40e - currently uninstallation is skipped
    # Any other option is invalid
    while getopts ":ud" opt; do
        case $opt in
            u)
                extract_pkg
                if [ $? -eq 0 ]; then
                    rpm_install
                else
                    printf "extract Failed!"
                fi
                cleanup_files
                exit 0
                ;;
            d)
                rpm_uninstall
                cleanup_files
                exit 0
                ;;
            \?)
                printf "Failed:$0 -$OPTARG unknown option"
                cleanup_files
                exit 1
                ;;
            :)
                printf "Failed:$0 -$OPTARG requires argument"
                cleanup_files
                exit 2
                ;;
        esac
    done

    # No arguments:
    printf "$0: no changes applied!"
    cleanup_files
}

# Script starts here
main $@
