#!/bin/sh
#
# Copyright (c) 2018 Juniper Networks, Inc.
# All rights reserved.
#
# Author: Vijay Kumar Burugu <vijaykg@juniper.net>
# Description: This script will invoke install/upgrade scripts. This is 
# invoked from Junos
#

INSTALL_ROOT=/.old
RPM_DB_PATH=/var/lib/rpm


function install()
{
	# Re-mount as read/write
	mount -o remount,rw ${INSTALL_ROOT}
	if [ $? -ne 0 ];then
	    echo "${INSTALL_ROOT} failed to remount[rw] , Exiting"
	    exit;
	fi
	
	echo "Invoke Install Script"
	cd ${PKG_PATH}
	echo "Start RPM install"

	for pkg in `ls ptx1k_firmware_install.sh`; do
		bash $pkg $RPM_DB_PATH $INSTALL_ROOT 
	done

	# re-mount as read only again
	mount -o remount,ro ${INSTALL_ROOT}
	if [ $? -ne 0 ];then
	    echo "${INSTALL_ROOT} failed to remount[ro]"
	fi

}

function upgrade()
{
	# Re-mount as read/write
	mount -o remount,rw ${INSTALL_ROOT}
	if [ $? -ne 0 ];then
	    echo "${INSTALL_ROOT} failed to remount[rw] , Exiting"
	    exit;
	fi
	
	echo "Invoke Install Script"
	cd ${PKG_PATH}
	echo "Start RPM install"
	
	for pkg in `ls ptx1k_firmware_upgrade.sh`; do
		bash $pkg $RPM_DB_PATH $INSTALL_ROOT 
	done

	# re-mount as read only again
	mount -o remount,ro ${INSTALL_ROOT}
	if [ $? -ne 0 ];then
	    echo "${INSTALL_ROOT} failed to remount[ro]"
	fi


}

function cleanup()
{
	echo "Invoke Cleanup Script"
	
	mount -o remount,rw ${INSTALL_ROOT}
	if [ $? -ne 0 ];then
	    echo "${INSTALL_ROOT} failed to remount[rw] , Exiting"
	    exit;
	fi

	#Find all RPM with group "ptx1k_firmware"
	PKG_LIST=$(rpm -qa --dbpath=${RPM_DB_PATH} | grep ptx1k_firmware)

	# Delete RPM's one by one, bail out on first failure
	for PKG_NAME in ${PKG_LIST}
	do
		rpm -e --dbpath=${RPM_DB_PATH} ${PKG_NAME}
		if [ $? == 0 ]; then
			echo "${PKG_NAME} removed"
		else
			echo "Failed to remove ${PKG_NAME}"
		fi
	done
	mount -o remount,ro ${INSTALL_ROOT}
	if [ $? -ne 0 ];then
	    echo "${INSTALL_ROOT} failed to remount[ro]"
	fi
}

if [ -z "$2" ]; then 
    PKG_PATH="/tmp"
else
    PKG_PATH=$2
fi

if [[ $1 == "-i" ]]; then
	install
elif [[ $1 == "-u" ]]; then
	upgrade
elif [[ $1 == "-d" ]]; then
        cleanup
fi
