#! /bin/sh

#
# Copyright (c) 2018 Juniper Networks, Inc.
# All rights reserved.
#
# Author: Vijay Kumar Burugu <vijaykg@juniper.net>
# Description: This script will install the bios RPM on host
#

RPM_DB_PATH=${1}
INSTALL_PREFIX=${2}
PKG_NAME=ptx1k_firmware-1.0-0*

echo "Upgrading ${PKG_NAME}"

rpm -qa --dbpath=${RPM_DB_PATH} | grep ${PKG_NAME}
if [ $? == 0 ]; then
    echo "${PKG_NAME} Already Installed"
    rpm -e --dbpath=${RPM_DB_PATH} ${PKG_NAME}
    if [ $? == 0 ]; then
        echo "Old ${PKG_NAME} removed"
    else
        echo "Failed to remove ${PKG_NAME}, bailing out"
        exit
    fi
fi

echo "Installing RPM"
rpm -ivh --prefix=${INSTALL_PREFIX} --nodeps --dbpath=${RPM_DB_PATH} ${PKG_NAME}.rpm
if [ $? == 0 ]; then
    echo "RPM ${PKG_NAME} installed successfully"
else
    echo "RPM ${PKG_NAME} installation failed"
fi
