#!/bin/sh

#
# Description:
#   Installation script triggerred by RPM install
#   Check the revision of firmware to upgrade
#

#Variables
I40E_IF=eth1
I40E_DRIVER=`/usr/sbin/ethtool -i $I40E_IF | grep driver | cut -d ":" -f 2 | tr -d [:blank:]`
krev=`uname -a |awk '{print $3}'`
NVM_REVISION=" "
CUR_REVISION=" "

function NVM_firmware_version ()
{
    # Get NVM  Version
    CUR_REVISION=$(ethtool -i $I40E_IF | grep "^version:" | cut -d ' ' -f2 )
    echo $CUR_REVISION
    if [[ "$CUR_REVISION" = "1.1.23" ]] || [[ "$CUR_REVISION" = "1.3.9-k" ]] ;then
        NVM_REVISION=$(ethtool -i $I40E_IF | grep firmware-version | cut -d " " -f 4 | tr -d [:alpha:])
        echo "NVM_version: $NVM_REVISION"
        echo "DRV_version: $CUR_REVISION"
    else 
        NVM_REVISION=$(ethtool -i $I40E_IF | grep firmware-version | cut -d " " -f 2 | tr -d [:alpha:])
        echo "NVM_version: $NVM_REVISION"
        echo "DRV_version: $CUR_REVISION"
    fi
}

function setup_fortville_link ()
{
    major=$(echo $NVM_REVISION | cut -d. -f1)
    minor=$(echo $NVM_REVISION | cut -d. -f2)
    if [ -d  /.old/lib/modules/$krev/kernel/drivers/net/ethernet/intel/i40e ]; then
        if [[ $major -gt 4 ]] || [[ ( $major -eq 4  && "$minor" > "41" ) ]] ; then
            # setup link to PF driver 2.4.3
            echo "Fortville NVM Firmware Version: $NVM_REVISION"
            if [ -e /.old/usr/share/i40e/i40e-2.4.3/i40e.ko ]; then
                cd  /.old/lib/modules/$krev/kernel/drivers/net/ethernet/intel/i40e
                mount -o rw,remount /.old
                ln -sf /usr/share/i40e/i40e-2.4.3/i40e.ko ./i40e.ko
                mount -o ro,remount /.old
            fi
        else
            # setup link to PF driver 1.1.23
            echo "Fortville NVM Firmware Version: $NVM_REVISION"
            if [ -e  /.old/usr/share/i40e/i40e-1.1.23/i40e.ko ]; then
                cd  /.old/lib/modules/$krev/kernel/drivers/net/ethernet/intel/i40e
		mount -o rw,remount /.old
                ln -sf /usr/share/i40e/i40e-1.1.23/i40e.ko ./i40e.ko
		mount -o ro,remount /.old
            fi
        fi
    fi
}

function link_to_latest_drv()
{
    #upgrade to latest just beofre FW upgrade
    if [ -d /lib/modules/$krev/kernel/drivers/net/ethernet/intel/i40e ]; then
        if [ -e /usr/share/i40e/i40e-2.4.3/i40e.ko ]; then
                cd  /.old/lib/modules/$krev/kernel/drivers/net/ethernet/intel/i40e
                mount -o rw,remount /.old
                ln -sf /usr/share/i40e/i40e-2.4.3/i40e.ko ./i40e.ko
		mount -o ro,remount /.old
                rmmod i40e
                insmod /usr/share/i40e/i40e-2.4.3/i40e.ko
                ifconfig $I40E_IF up
        fi
    fi
}

if [ ! -e /etc/nvm-update-version ]; then
    exit 0
fi

NEW_I40E_REV=`cat /etc/nvm-update-version | grep re-i40e-NVM | cut -d ":" -f 2`
if [ "$I40E_DRIVER" == "i40e" ] ; then
    link_to_latest_drv
    NVM_firmware_version

    if [ "$NEW_I40E_REV" != "$NVM_REVISION" ]; then
        echo "Need Manual procedure to upgrade i40e firmware revision from $NVM_REVISION to  $NEW_I40E_REV"
        echo "upgrading i40e firmware ....."
        cd /usr/share/i40e/XL710/Linux_x64/
        ./nvmupdate64e -u -l -o update.xml -c nvmupdate.cfg
        echo "Upgrade complete please power reboot"
        echo "You may notify to  power reboot again after reboot if required"
	sleep 120
    else
        echo "i40e firmware revision is the latest to $NVM_REVISION"
	setup_fortville_link
        rm -f /etc/nvm-update-version
        echo "Host reboot is required to load compatible i40e driver"
        sleep 60
    fi
fi
