#!/bin/sh
#
# $Id$
#
# Copyright (c) 2015, Juniper Networks, Inc.
# All rights reserved.
#
# jfirmware-vmhost installation script. This script copies files from guest to host by using vhclient
#

pkgtools=${PKGTOOLS:-/usr/libexec}


VMHOST_FIRMWARE_PKG=`ls ${PKGDIR}/contents/vmhost-firmware-*.tgz`
VMHOST_FIRMWARE_FILE=`basename $VMHOST_FIRMWARE_PKG`
I40E_SCRIPT=i40e_pkg_install.sh
BIOS_SCRIPT=bios_pkg_install.sh
PTX1K_FIRMWARE_SCRIPT=ptx1k_firmware.sh
I40E_PKG=i40e_pkg.tgz
PATH_TO_COPY=/tmp

platform=`sysctl hw.product.pvi_model | awk '{print $2}'`

re_name=`sysctl hw.re.name | awk '{print $2}'`
printf "[ platform = $platform ; re_name = $re_name ]\n"

printf "Pushing $VMHOST_FIRMWARE_PKG to host ..."
/usr/bin/vhclient rcp $VMHOST_FIRMWARE_PKG $PATH_TO_COPY/
if [ $? -eq 0 ]; then
    printf "done. "
else
    printf "failed! "
fi
printf "\n"

printf "Extracting $VMHOST_FIRMWARE_PKG ..."
/usr/bin/vhclient /bin/tar -C $PATH_TO_COPY/ -xzf $PATH_TO_COPY/$VMHOST_FIRMWARE_FILE
if [ $? -eq 0 ]; then
    printf "done. "
else
    printf "failed! "
fi
printf "\n"

case "$platform" in
ptx1000|ptx10002-60c|qfx10002-60c)
    /usr/bin/vhclient /bin/chmod 755 $PATH_TO_COPY/$PTX1K_FIRMWARE_SCRIPT
    /usr/bin/vhclient $PATH_TO_COPY/$PTX1K_FIRMWARE_SCRIPT -u $PATH_TO_COPY
    if [ $? -eq 0 ]; then
        printf "Upgrading $platform firmware on host ... done."
    else
        printf "Upgrading $platform firmware on host ... failed!"
    fi
    printf "\n"
    ;;
*)
    /usr/bin/vhclient /bin/chmod 755 $PATH_TO_COPY/$I40E_SCRIPT
    /usr/bin/vhclient $PATH_TO_COPY/$I40E_SCRIPT -u
    if [ $? -eq 0 ]; then
        printf "Installing i40e pkg on host ... done."
    else
        printf "Installing i40e pkg on host ... failed!"
    fi
    printf "\n"

    /usr/bin/vhclient /bin/chmod 755 $PATH_TO_COPY/$BIOS_SCRIPT
    /usr/bin/vhclient $PATH_TO_COPY/$BIOS_SCRIPT -u
    if [ $? -eq 0 ]; then
        printf "Installing bios pkg on host ... done."
    else
        printf "Installing bios pkg on host ... failed!"
    fi
    printf "\n"
    ;;
esac

ln -sf  ${PKGDIR}/firmware/*  /usr/share/pfe/firmware/

/usr/bin/vhclient /bin/rm -f $PATH_TO_COPY/vmhost-firmware-* $PATH_TO_COPY/bios_pkg* $PATH_TO_COPY/i40e_pkg* $PATH_TO_COPY/vmhost-version* $PATH_TO_COPY/ptx1k_firmware*
printf "\n"

